/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmCoBankDto;

public class CmCoBankDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CM_CO_BANK";
	public static final String KEY_1 = "CO_BANK_CODE";  // ЋsR[h
	// 
	public static final String COL_CO_BANK_CODE = "CO_BANK_CODE" ;	// ЋsR[h
	public static final String COL_BANK_CODE    = "BANK_CODE"    ;	// sR[h
	public static final String COL_BRANCH_CODE  = "BRANCH_CODE"  ;	// xXR[h
	public static final String COL_ACCOUNT_TYPE = "ACCOUNT_TYPE" ;	// a敪
	public static final String COL_ACCOUNT_NO   = "ACCOUNT_NO"   ;	// ԍ
	public static final String COL_DELETE_FLAG  = "DELETE_FLAG"  ;	// 폜tO

	/**
	 * RXgN^
	 */
	public CmCoBankDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmCoBankDto> mappingAll() throws SQLException {
		List<CmCoBankDto> all = new ArrayList<CmCoBankDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmCoBankDto CM_CO_BANKR[h
	 * @throws SQLException
	 */
	private CmCoBankDto mapping() throws SQLException {
		CmCoBankDto dto = new CmCoBankDto();
		dto.setCoBankCode  (rs.getString(COL_CO_BANK_CODE ));	// ЋsR[h
		dto.setBankCode    (rs.getString(COL_BANK_CODE    ));	// sR[h
		dto.setBranchCode  (rs.getString(COL_BRANCH_CODE  ));	// xXR[h
		dto.setAccountType (rs.getString(COL_ACCOUNT_TYPE ));	// a敪
		dto.setAccountNo   (rs.getString(COL_ACCOUNT_NO   ));	// ԍ
		dto.setDeleteFlag  (rs.getInt   (COL_DELETE_FLAG  ));	// 폜tO
		mappingCommonInfo(dto);
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List o^
	 * @throws SQLException
	 * @throws Illega|AccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCoBankDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmCoBankDto> all = mappingAll();
			return all;	
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param coBankCode ЋsR[h(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCoBankDto findForKey(String coBankCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++,coBankCode);
			executeQuery();
			CmCoBankDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param CoBankCode ЋsR[h(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCoBankDto findForUpdate(String CoBankCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, CoBankCode);
			executeQuery();
			CmCoBankDto CmCoBankDto = null;
			if (rs.next()) {
				CmCoBankDto = mapping();
			}
			return CmCoBankDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCoBankDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmCoBankDto dto, boolean needLog) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getCoBankCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Lf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCoBankDto> findAvailable(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			executeQuery();
			List<CmCoBankDto> all = mappingAll();
			return all;			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmCoBankDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getCoBankCode  ());	// ЋsR[h
		setParam(index++, dto.getBankCode    ());	// sR[h
		setParam(index++, dto.getBranchCode  ());	// xXR[h
		setParam(index++, dto.getAccountType ());	// a敪
		setParam(index++, dto.getAccountNo   ());	// ԍ
		setParam(index++, dto.getDeleteFlag  ());	// 폜tO
		setCommonParams(isInsert);
	}
}
